Option Strict Off
Option Explicit On
Module modCommon
	
	'///////////////////////////////////////////////////////////////////////////////
	' Is[X̃NA
	
	Public Sub ClearSelectedPieces(ByRef tvTarget As AxKnTViewLib.AxKnTView)
		
		Dim intIndex As Short
		
		For intIndex = tvTarget.SelectedPieces.Count To 1 Step -1
			
			tvTarget.SelectedPieces.Item(intIndex).Selected = False
			
		Next 
		
	End Sub
	
	'///////////////////////////////////////////////////////////////////////////////
	' Is[X̍폜
	
	Public Sub DeleteSelectedPieces(ByRef tvTarget As AxKnTViewLib.AxKnTView)
		
		Dim intIndex As Short
		Dim piecesTarget As KnTViewLib.SelectedPieces
		Dim itemTarget As KnTViewLib.Item
		
		piecesTarget = tvTarget.SelectedPieces
		
		For intIndex = piecesTarget.Count To 1 Step -1
			
			itemTarget = tvTarget.Items.Item(piecesTarget.Item(intIndex).ItemIndex)
			itemTarget.Pieces.Remove(piecesTarget.Item(intIndex).Index)
			
		Next 
		
	End Sub
	
	'///////////////////////////////////////////////////////////////////////////////
	' CX^C
	
	Public Function GetNextLineStyle(ByVal styleCurrent As KnTViewLib.TivLineStyle, ByRef lbl As System.Windows.Forms.Label) As KnTViewLib.TivLineStyle
		
		Select Case styleCurrent
		Case KnTViewLib.TivLineStyle.tivLineSolid
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineDash

		Case KnTViewLib.TivLineStyle.tivLineDash
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineDashDot

		Case KnTViewLib.TivLineStyle.tivLineDashDot
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineDashDotDot

		Case KnTViewLib.TivLineStyle.tivLineDashDotDot
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineDot

		Case KnTViewLib.TivLineStyle.tivLineDot
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineNull

		Case KnTViewLib.TivLineStyle.tivLineNull
			GetNextLineStyle = KnTViewLib.TivLineStyle.tivLineSolid

		End Select
		
		lbl.Text = GetLineStyleName(GetNextLineStyle)
		
	End Function
	
	'///////////////////////////////////////////////////////////////////////////////
	' CX^C̎擾
	
	Public Function GetLineStyleName(ByVal styleCurrent As KnTViewLib.TivLineStyle) As String
		
		Select Case styleCurrent
		Case KnTViewLib.TivLineStyle.tivLineSolid
			GetLineStyleName = "tivLineSolid"

		Case KnTViewLib.TivLineStyle.tivLineDash
			GetLineStyleName = "tivLineDash"

		Case KnTViewLib.TivLineStyle.tivLineDashDot
			GetLineStyleName = "tivLineDashDot"

		Case KnTViewLib.TivLineStyle.tivLineDashDotDot
			GetLineStyleName = "tivLineDashDotDot"

		Case KnTViewLib.TivLineStyle.tivLineDot
			GetLineStyleName = "tivLineDot"

		Case KnTViewLib.TivLineStyle.tivLineNull
			GetLineStyleName = "tivLineNull"

		End Select
		
	End Function
	
	'///////////////////////////////////////////////////////////////////////////////
	' F
	
	Public Function GetNextColor(ByVal color As Integer, ByRef lbl As System.Windows.Forms.Label) As Integer
		
		Select Case color
		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Lime)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Lime)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Blue)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Blue)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Yellow)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Yellow)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.White)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.White)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Cyan)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Cyan)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta)
			GetNextColor = &H8080FF

		Case &H8080FF
			GetNextColor = &H80C0FF

		Case &H80C0FF
			GetNextColor = &H80FFFF

		Case &H80FFFF
			GetNextColor = &H80FF80

		Case &H80FF80
			GetNextColor = &HFFFF80

		Case &HFFFF80
			GetNextColor = &HFF8080

		Case &HFF8080
			GetNextColor = &HFF80FF

		Case &HFF80FF
			GetNextColor = &HE0E0E0

		Case &HE0E0E0
			GetNextColor = &HC0C0C0

		Case &HC0C0C0
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ScrollBar)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ScrollBar)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Desktop)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Desktop)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaption)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaption)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaption)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaption)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Menu)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Menu)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Window)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Window)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowFrame)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowFrame)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.MenuText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.MenuText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaptionText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaptionText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveBorder)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveBorder)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveBorder)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveBorder)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.AppWorkspace)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.AppWorkspace)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Highlight)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Highlight)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.HighlightText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.HighlightText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Control)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Control)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDark)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDark)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.GrayText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.GrayText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaptionText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaptionText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLightLight)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLightLight)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDarkDark)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDarkDark)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLight)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLight)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InfoText)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InfoText)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Info)

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Info)
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red)

		Case Else
			GetNextColor = System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black)

		End Select
		
		lbl.Text = GetColorName(GetNextColor)
		
	End Function
	
	'///////////////////////////////////////////////////////////////////////////////
	' F̎擾
	
	Public Function GetColorName(ByVal color As Integer) As String
		
		Select Case color
		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red)
			GetColorName = ""

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Lime)
			GetColorName = ""

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Blue)
			GetColorName = ""

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Yellow)
			GetColorName = "F"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.White)
			GetColorName = ""

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black)
			GetColorName = ""

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Cyan)
			GetColorName = "F"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta)
			GetColorName = "}[_"

		Case &H8080FF
			GetColorName = ""

		Case &H80C0FF
			GetColorName = "IW"

		Case &H80FFFF
			GetColorName = "F"

		Case &H80FF80
			GetColorName = ""

		Case &HFFFF80
			GetColorName = "F"

		Case &HFF8080
			GetColorName = ""

		Case &HFF80FF
			GetColorName = "}[_"

		Case &HE0E0E0
			GetColorName = "DF"

		Case &HC0C0C0
			GetColorName = "DF"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ScrollBar)
			GetColorName = "XN[ o["

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Desktop)
			GetColorName = "fXNgbv"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaption)
			GetColorName = "ActiveWindow̃^Cgo["

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaption)
			GetColorName = "ActiveWindow̃^Cgo["

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Menu)
			GetColorName = "j[̔wiF"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Window)
			GetColorName = "EBhE̔wiF"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowFrame)
			GetColorName = "EBhẼt["

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.MenuText)
			GetColorName = "j[̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.WindowText)
			GetColorName = "EBhE̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveCaptionText)
			GetColorName = "LvV̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ActiveBorder)
			GetColorName = "ActiveWindow̋E"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveBorder)
			GetColorName = "ActiveWindow̋E"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.AppWorkspace)
			GetColorName = "MDIAvP[V̔wiF"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Highlight)
			GetColorName = "Rg[ł̔wiF"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.HighlightText)
			GetColorName = "Rg[ł̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Control)
			GetColorName = "{^̕\ʂ̗̓Iȕ\"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDark)
			GetColorName = "{^̒[̗̓Iȕ\"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.GrayText)
			GetColorName = "WF\()̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlText)
			GetColorName = "vbV{^̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InactiveCaptionText)
			GetColorName = "ANeBuLvV̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLightLight)
			GetColorName = "3Dōł邭\vf"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlDarkDark)
			GetColorName = "3DōłÂ\vf̉e"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.ControlLight)
			GetColorName = "3D2Ԗڂɖ邭\vf"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.InfoText)
			GetColorName = "c[ qg̕"

		Case System.Drawing.ColorTranslator.ToOle(System.Drawing.SystemColors.Info)
			GetColorName = "c[ qg̔wiF"

		Case Else
			GetColorName = Hex(color)

		End Select
		
	End Function
	
	'///////////////////////////////////////////////////////////////////////////////
	' hԂ
	
	Public Function GetNextFillPattern(ByVal pattern As KnTViewLib.TivFillPattern, ByRef lbl As System.Windows.Forms.Label) As KnTViewLib.TivFillPattern
		
		Select Case pattern
		Case KnTViewLib.TivFillPattern.tivPattern10Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern20Percent

		Case KnTViewLib.TivFillPattern.tivPattern20Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern25Percent

		Case KnTViewLib.TivFillPattern.tivPattern25Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern30Percent

		Case KnTViewLib.TivFillPattern.tivPattern30Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern3D

		Case KnTViewLib.TivFillPattern.tivPattern3D
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern40Percent

		Case KnTViewLib.TivFillPattern.tivPattern40Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern50Percent
			lbl.Text = "tivPattern50Percent"

		Case KnTViewLib.TivFillPattern.tivPattern50Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern5Percent

		Case KnTViewLib.TivFillPattern.tivPattern5Percent
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternBackwardDiagonal

		Case KnTViewLib.TivFillPattern.tivPatternBackwardDiagonal
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternCross

		Case KnTViewLib.TivFillPattern.tivPatternCross
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternDiagonalCross

		Case KnTViewLib.TivFillPattern.tivPatternDiagonalCross
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternFineBackwardDiagonal

		Case KnTViewLib.TivFillPattern.tivPatternFineBackwardDiagonal
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternFineDiagonalCross

		Case KnTViewLib.TivFillPattern.tivPatternFineDiagonalCross
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternFineForwardDiagonal

		Case KnTViewLib.TivFillPattern.tivPatternFineForwardDiagonal
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternForwardDiagonal

		Case KnTViewLib.TivFillPattern.tivPatternForwardDiagonal
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternHorizontal

		Case KnTViewLib.TivFillPattern.tivPatternHorizontal
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternHorizontalGradation

		Case KnTViewLib.TivFillPattern.tivPatternHorizontalGradation
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternVertical

		Case KnTViewLib.TivFillPattern.tivPatternVertical
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternVerticalGradation

		Case KnTViewLib.TivFillPattern.tivPatternVerticalGradation
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPatternNull

		Case KnTViewLib.TivFillPattern.tivPatternNull
			GetNextFillPattern = KnTViewLib.TivFillPattern.tivPattern10Percent

		End Select
		
		lbl.Text = GetFillPatternName(GetNextFillPattern)
		
	End Function
	
	'///////////////////////////////////////////////////////////////////////////////
	' hԂ̎擾
	
	Public Function GetFillPatternName(ByVal pattern As KnTViewLib.TivFillPattern) As String
		
		Select Case pattern
		Case KnTViewLib.TivFillPattern.tivPattern10Percent
			GetFillPatternName = "tivPattern10Percent"

		Case KnTViewLib.TivFillPattern.tivPattern20Percent
			GetFillPatternName = "tivPattern20Percent"

		Case KnTViewLib.TivFillPattern.tivPattern25Percent
			GetFillPatternName = "tivPattern25Percent"

		Case KnTViewLib.TivFillPattern.tivPattern30Percent
			GetFillPatternName = "tivPattern30Percent"

		Case KnTViewLib.TivFillPattern.tivPattern3D
			GetFillPatternName = "tivPattern3D"

		Case KnTViewLib.TivFillPattern.tivPattern40Percent
			GetFillPatternName = "tivPattern40Percent"

		Case KnTViewLib.TivFillPattern.tivPattern50Percent
			GetFillPatternName = "tivPattern50Percent"

		Case KnTViewLib.TivFillPattern.tivPattern5Percent
			GetFillPatternName = "tivPattern5Percent"

		Case KnTViewLib.TivFillPattern.tivPatternBackwardDiagonal
			GetFillPatternName = "tivPatternBackwardDiagonal"

		Case KnTViewLib.TivFillPattern.tivPatternCross
			GetFillPatternName = "tivPatternCross"

		Case KnTViewLib.TivFillPattern.tivPatternDiagonalCross
			GetFillPatternName = "tivPatternDiagonalCross"

		Case KnTViewLib.TivFillPattern.tivPatternFineBackwardDiagonal
			GetFillPatternName = "tivPatternFineBackwardDiagonal"

		Case KnTViewLib.TivFillPattern.tivPatternFineDiagonalCross
			GetFillPatternName = "tivPatternFineDiagonalCross"

		Case KnTViewLib.TivFillPattern.tivPatternFineForwardDiagonal
			GetFillPatternName = "tivPatternFineForwardDiagonal"

		Case KnTViewLib.TivFillPattern.tivPatternForwardDiagonal
			GetFillPatternName = "tivPatternForwardDiagonal"

		Case KnTViewLib.TivFillPattern.tivPatternHorizontal
			GetFillPatternName = "tivPatternHorizontal"

		Case KnTViewLib.TivFillPattern.tivPatternHorizontalGradation
			GetFillPatternName = "tivPatternHorizontalGradation"

		Case KnTViewLib.TivFillPattern.tivPatternVertical
			GetFillPatternName = "tivPatternVertical"

		Case KnTViewLib.TivFillPattern.tivPatternVerticalGradation
			GetFillPatternName = "tivPatternVerticalGradation"

		Case KnTViewLib.TivFillPattern.tivPatternNull
			GetFillPatternName = "tivPatternNull"

		End Select
		
	End Function

	'///////////////////////////////////////////////////////////////////////////////
	' UInt32Integerɕϊ

	Public Function UInt32ToInt32(ByVal uintValue As UInt32) As Integer

		Dim nValue As Integer
		Dim strValue As String

		strValue = uintValue.ToString("X")

		UInt32ToInt32 = System.Convert.ToInt32(strValue, 16)

	End Function

	'///////////////////////////////////////////////////////////////////////////////
	' IntegerUInt32ɕϊ

	Public Function Int32ToUInt32(ByVal intValue As Integer) As UInt32

		Dim nColor As Integer
		Dim strColor As String

		strColor = intValue.ToString("X")

		Int32ToUInt32 = System.Convert.ToUInt32(strColor, 16)

	End Function

End Module